
// FSDIndexerDlg.h : header file
//

#pragma once
#include "afxwin.h"
#include "Contentlist.h"
#include "progress.h"
#include "ftpclient.h"
#include "options.h"
#include "connhand.h"

extern ConnHand ch;
// CFSDIndexerDlg dialog
class CFSDIndexerDlg : public CDialog
{
// Construction
public:
	CFSDIndexerDlg(CWnd* pParent = NULL);	// standard constructor


	bool UpdateSel;
	bool UpdateName;
// Dialog Data
	enum { IDD = IDD_FSDINDEXER_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	ContentItems * items;

	int CurSel;

// Implementation
protected:
	HICON m_hIcon;
	CProgress pd;
	COptions opt;
	int CurType;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnOpenContentXML();
	void LoadContent();
	afx_msg void OnSaveContentXML();
	CListBox m_GameList;
	afx_msg void OnLbnSelchangeList1();
	CEdit GameTitle;
	void SelItem(int NewSel);
	afx_msg void OnTitleChange();
	afx_msg void OnDataForCurrent();
	afx_msg void OnDataForAll();
	void GetData(int ToGet);
	bool GetBoxart(wstring id, wstring imageurl,wstring destfile,bool CheckDefault = true,bool Background = false);
	CEdit m_Desc;
	CEdit m_Genres;
	CEdit m_Manuf;
	CEdit m_Path;
	void GetMissingIcon(ContentItem * item);
	void GetScreenshots(ContentItem * item, wstring prodid);
	CButton m_HasIcon;
	CButton m_HasBoxart;
	CEdit m_Screenshots;
	bool Changed;
	afx_msg void OnBnClickedCancel();
	afx_msg void OnEnChangeEdit3();
	afx_msg void OnEnChangeEdit5();
	afx_msg void OnViewIcon();
	afx_msg void OnViewBoxArt();
	void DownloadAndOpen(wstring file);
	CListBox m_SSList;
	afx_msg void OnViewScreenshot();
	CEdit m_AltUrl;
	CEdit m_TitleID;
	CEdit m_Version;
	CEdit m_Disc;
	int m_ShowOnlyIncomplete;
	afx_msg void OnChangeViewInc();
	afx_msg void OnChangeViewInc2();
	void XBoxcom(ContentItem * item, wstring url, wstring& prodid, wstring& imageurl);
	void MarketplaceData(ContentItem * item, wstring& prodid, wstring& imageurl);
	void GetScreenshotsAlt(ContentItem * item, AltInfo* ai);
	char OKChars[256];
	void InitOKChars();
	wstring StripBadChars(wstring in);
	afx_msg void OnRemoveBoxArt();
	afx_msg void OnDelIcon();
	afx_msg void OnClearScreenshots();
	afx_msg	void OnTimer (UINT TimerVal);
	afx_msg void OnAddBoxart();
	afx_msg void OnAddIcon();
	afx_msg void OnAddScreenshot();
	CComboBox m_Type;
	afx_msg void OnChangeType();
	CButton m_HadBackground;
	afx_msg void OnAddBackground();
	afx_msg void OnViewBackground();
	afx_msg void OnRemoveBackground();
};
